/*
    FPSE runtime functions
    ======================

    Written by BERO
*/

#include "fpse.h"

void rfe(void)
{
	SR = (SR & ~0xf)| ((SR>>2)&0xf);
	PRINTF("rfe:%x\n",(int)(SR));
}

UINT32 exception(int cd,UINT32 pc)
{
//       if (cd == E_Bp*4) cd = E_Sys*4; // Avoid break opcode
	PRINTF("Exception:%x %x\n",cd,(int)pc);
	EPC=pc;
	//CAUSE = (CAUSE & ~0x3c) | cd;
	CAUSE = cd;
	SR = (SR & ~0x3f)| ((SR<<2)&0x3f);
	return jmppc(0x80000080);
}

void compile_go(void)
{
	void (*func)();
	func = (void *)jmppc(PC);
	func();
}

void go(void)
{
    int x;

    while (!stop) {
        if (update_counter()) Interrupt();
        for (x=0;x<16;x++) doInst();
    }
}
